/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	CollectableInterface
**
** DESCRIPTION:	Interface for collectables
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef COLLECTABLE_INTERFACE_H
#define COLLECTABLE_INTERFACE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "Collectable.h"

class CVillager;

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class ICollectable
{
	//interface methods
	//setup

	// process
	public:		virtual const bool Carry(CVillager &Villager, const ECarrying eCarrying) = 0;
	public:		virtual void Drop(CVillager &Villager, const ECarrying eCarrying) = 0;

	// access
	public:		virtual const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos) = 0;
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/